export default {
    content: [
        './templates/**/*.php',
        '**/*.html',
        './dev_assets/**/*.js'
    ],
    theme: {
        extend: {
            colors: {
                base: {
                    white: '#ffffff',
                    black: '#000000',
                },
                brand: {
                    gold: '#f7b536',
                    oil: '#2d2d2d',
                },
                gray: {
                    25: '#fcfcfd',
                    50: '#f9fafb',
                    100: '#f2f4f7',
                    200: '#eaecf0',
                    300: '#d0d5dd',
                    400: '#98a2b3',
                    500: '#667085',
                    600: '#475467',
                    700: '#344054',
                    800: '#1d2939',
                    900: '#101828',
                },
                primary: {
                    25: '#fafcff',
                    50: '#f0f7ff',
                    100: '#cce4ff',
                    200: '#99caff',
                    300: '#57a8ff',
                    400: '#007bff',
                    500: '#0065d1',
                    600: '#004fa3',
                    700: '#003975',
                    800: '#002247',
                    900: '#000c19',
                },
                error: {
                    25: '#fef9fa',
                    50: '#fdf0f3',
                    100: '#f9d2d9',
                    200: '#f2a6b3',
                    300: '#ea6c80',
                    400: '#df2040',
                    500: '#b71a34',
                    600: '#D92D20',
                    700: '#650e1d',
                    800: '#3d0912',
                    900: '#160306',
                },
                warning: {
                    25: '#fffcf5',
                    50: '#fffaeb',
                    100: '#fef0c7',
                    200: '#fedf89',
                    300: '#fec84b',
                    400: '#fdb022',
                    500: '#f79009',
                    600: '#dc6803',
                    700: '#b54708',
                    800: '#93370d',
                    900: '#7a2e0e',
                },
                success: {
                    25: '#f6fef9',
                    50: '#ecfdf3',
                    100: '#d1fadf',
                    200: '#a6f4c5',
                    300: '#6ce9a6',
                    400: '#32d583',
                    500: '#12b76a',
                    600: '#039855',
                    700: '#027a48',
                    800: '#05603a',
                    900: '#054f31'
                },
                cyan: {
                    25:'#f5feff',
                    50:'#ecfdff',
                    100:'#cff9fe',
                    200:'#a5f0fc',
                    300:'#67e3f9',
                    400:'#22ccee',
                    500:'#06aed4',
                    600:'#088ab2',
                    700:'#0e7090',
                    800:'#155b75',
                    900:'#164c63'
                },
                bluelight:{
                    '25': "#f5fbff",
                    '50': "#f0f9ff",
                    '100': "#e0f2fe",
                    '200': "#b9e6fe",
                    '300': "#7cd4fd",
                    '400': "#36bffa",
                    '500': "#0ba5ec",
                    '600': "#0086c9",
                    '700': "#026aa2",
                    '800': "#065986",
                    '900': "#0b4a6f"
                },
                blue:{
                    '25': "#f5faff",
                    '50': "#eff8ff",
                    '100': "#d1e9ff",
                    '200': "#b2ddff",
                    '300': "#84caff",
                    '400': "#53b1fd",
                    '500': "#2e90fa",
                    '600': "#1570ef",
                    '700': "#175cd3",
                    '800': "#1849a9",
                    '900': "#194185"
                },
                indigo:{
                    '25': "#f5f8ff",
                    '50': "#eef4ff",
                    '100': "#e0eaff",
                    '200': "#c7d7fe",
                    '300': "#a4bcfd",
                    '400': "#8098f9",
                    '500': "#6172f3",
                    '600': "#444ce7",
                    '700': "#3538cd",
                    '800': "#2d31a6",
                    '900': "#2d3282"
                }
            },
            container: {
                center: true,
                padding: {
                    DEFAULT: '.5rem',
                }
            }
        }
    }
}
